<?php
header("Content-Type: application/json");
require "config.php";

$key  = strtoupper($_GET['key'] ?? '');
$hwid = $_GET['hwid'] ?? '';

$q = $conn->prepare(
    "SELECT * FROM license_keys WHERE license_key=? AND status=1 LIMIT 1"
);
$q->bind_param("s", $key);
$q->execute();
$r = $q->get_result();

if ($r->num_rows == 0) {
    exit(json_encode(["status"=>"error","message"=>"KEY INVALID"]));
}

$row = $r->fetch_assoc();

if ($row['expire'] != 0 && time() > $row['expire']) {
    exit(json_encode(["status"=>"error","message"=>"KEY EXPIRED"]));
}

if ($row['hwid'] && $row['hwid'] !== $hwid) {
    exit(json_encode(["status"=>"error","message"=>"KEY USED ON OTHER DEVICE"]));
}

if (!$row['hwid'] && $hwid) {
    $u = $conn->prepare("UPDATE license_keys SET hwid=? WHERE id=?");
    $u->bind_param("si", $hwid, $row['id']);
    $u->execute();
}

echo json_encode([
    "status" => "success",
    "type"   => $row['type'],
    "expire" => intval($row['expire'])
]);
